<?php
/**
 * QR Code Generation Helper
 * Uses PHP GD library to generate QR codes
 * For production, consider using a library like phpqrcode
 */

/**
 * Generate QR Code as base64 image
 * @param string $data Data to encode in QR code
 * @param int $size Size of QR code (default 200)
 * @return string Base64 encoded image
 */
function generateQRCode($data, $size = 200) {
    // Simple QR code generation using GD
    // Note: For production, use a proper QR library like phpqrcode or endroid/qr-code
    
    // Create image
    $image = imagecreatetruecolor($size, $size);
    
    // Colors
    $white = imagecolorallocate($image, 255, 255, 255);
    $black = imagecolorallocate($image, 0, 0, 0);
    
    // Fill white background
    imagefilledrectangle($image, 0, 0, $size, $size, $white);
    
    // Simple pattern (for demo - use proper QR library in production)
    // This is a placeholder - you should use a QR code library
    // For now, we'll create a simple pattern that represents a QR code
    
    // Draw a simple grid pattern (placeholder)
    $gridSize = 10;
    for ($x = 0; $x < $size; $x += $gridSize) {
        for ($y = 0; $y < $size; $y += $gridSize) {
            if (($x + $y) % ($gridSize * 2) === 0) {
                imagefilledrectangle($image, $x, $y, $x + $gridSize - 1, $y + $gridSize - 1, $black);
            }
        }
    }
    
    // Output as base64
    ob_start();
    imagepng($image);
    $imageData = ob_get_contents();
    ob_end_clean();
    imagedestroy($image);
    
    return 'data:image/png;base64,' . base64_encode($imageData);
}

/**
 * Generate QR Code using external service (fallback)
 * @param string $data
 * @param int $size
 * @return string URL to QR code
 */
function generateQRCodeURL($data, $size = 200) {
    $encoded = urlencode($data);
    return "https://api.qrserver.com/v1/create-qr-code/?size={$size}x{$size}&data={$encoded}";
}
